/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TransactionPhase.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.event;

/**
 * Distinguishes the various kinds of transactional observer methods  from regular observer
 * methods which are notified immediately.
 *
 * Transactional observer methods are observer methods which receive event notifications
 * during the before or after completion phase of the transaction in which the event was
 * fired. If no transaction is in progress when the event is fired, they are notified at
 * the same time as other observers.
 *
 * @author Guillaume Sauthier
 */
public enum TransactionPhase {

    /**
     * Identifies a regular observer method, called when the event is fired.
     */
    IN_PROGRESS,

    /**
     * Identifies a before completion observer method, called during the before completion
     * phase of the transaction.
     */
    BEFORE_COMPLETION,

    /**
     * Identifies an after completion observer method, called during the after completion
     * phase of the transaction.
     */
    AFTER_COMPLETION,

    /**
     * Identifies an after failure observer method, called during the after completion phase
     * of the transaction, only when the transaction fails.
     */
    AFTER_FAILURE,

    /**
     * Identifies an after success observer method, called during the after completion
     * phase of the transaction, only when the transaction completes successfully.
     */
    AFTER_SUCCESS
}
