/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: package-info.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

/**
 * Annotations and interfaces relating to events.
 *
 * {@linkplain javax.enterprise.inject Beans} may produce and consume events. Events allows beans to interact
 * in a completely decoupled fashion, with no compile-time dependency between the interacting beans. Most
 * importantly, it allows stateful beans in one architectural tier of the application to synchronize
 * their internal state with state changes that occur in a different tier.
 *
 * An event comprises:
 * <ul>
 *  <li>A Java object, called the event object</li>
 *  <li>A (possibly empty) set of instances of qualifier types, called the event qualifiers</li>
 * </ul>
 *
 * The {@link javax.enterprise.event.Event} interface is used to fire events.
 *
 * <h1>Event objects and event types</h1>
 *
 * The event object acts as a payload, to propagate state from producer to consumer. An event object is an
 * instance of a concrete Java class with no type variables.
 *
 * The event types of the event include all super-classes and interfaces of the runtime class of the
 * event object. An event type may not contain a type variable.
 *
 * <h1>Event qualifiers</h1>
 *
 * The event qualifiers act as topic selectors, allowing the consumer to narrow the set of events it
 * observes. An event qualifier may be an instance of any qualifier type.
 *
 * <h1>Observer methods</h1>
 *
 * An {@linkplain javax.enterprise.event.Observes observer method} allows the application to receive
 * and respond to event notifications. It acts as event consumer, observing events of a specific
 * type, with a specific set of qualifiers. Any Java type may be observed by an observer method.
 *
 * An observer method is a method of a bean class or {@linkplain javax.enterprise.inject.spi.Extension extension}
 * with a parameter annotated {@linkplain javax.enterprise.event.Observes @Observes}.
 *
 * An observer method will be notified of an event if:
 * <ul>
 *  <li>the event object is assignable to the type observed by the observer method,</li>
 *  <li>the observer method has all the event qualifiers of the event, and</li>
 *  <li>either the event is not a {@linkplain javax.enterprise.inject.spi container life-cycle event},
 *      or the observer method belongs to an {@linkplain javax.enterprise.inject.spi.Extension extension}.</li>
 * </ul>
 *
 * If the observer method is a {@linkplain javax.enterprise.event.TransactionPhase transactional observer method}
 * and there is a JTA transaction in progress when the event is fired, the observer method is notified
 * during the appropriate transaction completion phase. Otherwise, the observer is notified when the
 * event is fired.
 *
 * The order in which observer methods are called is not defined, and so portable applications
 * should not rely upon the order in which observers are called.
 *
 * Observer methods may throw exceptions:
 * <ul>
 *  <li>If the observer method is a {@linkplain javax.enterprise.event.TransactionPhase transactional observer method},
 *      any exception is caught and logged by the container.</li>
 *  <li>Otherwise, the exception aborts processing of the event. No other observer methods of that event will
 *      be called. The exception is re-thrown. If the exception is a checked exception, it is wrapped and re-thrown as
 *      an (unchecked) {@link javax.enterprise.event.ObserverException}.</li>
 * </ul>
 *
 * @see javax.enterprise.inject
 * @see javax.enterprise.event.Observes
 * @see javax.enterprise.event.Event
 * @see javax.inject.Qualifier
 */
package javax.enterprise.event;