/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Streamable.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;
 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Streamable interface enables a resource adapter to extract data
 * from an input Record or set data into an output Record as a stream
 * of bytes.<br/>
 * 
 * The Streamable interface provides a resource adapter's view of the
 * data that has been set in a Record instance by a component.<br/>
 * 
 * The Streamable interface is not directly used by a component. It
 * is used by a resource adapter implementation. A component uses
 * {@link Record} or any derived interfaces to manage records.
 * @since 0.8
 * @author Guillaume Sauthier
 */
public interface Streamable {

    /**
     * Read data from an {@link InputStream} and initialize fields of
     * a Streamable object.
     * @param istream {@link InputStream} that represents a resource
     *        adapter specific internal representation of fields of
     *        a Streamable object
     * @throws IOException
     */
    void read(InputStream istream) throws IOException;
    
    /**
     * Write fields of a Streamable object to an {@link OutputStream}.
     * @param ostream {@link OutputStream} that holds value of a
     *        Streamable object
     * @throws IOException
     */
    void write(OutputStream ostream) throws IOException;
}
