/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LocalTransactionException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * A LocalTransactionException represents various error conditions related to the
 * local transaction management contract. The Java Transaction API specification
 * specifies the javax.transaction.xa.XAException class for exceptions related to
 * {@link javax.transaction.xa.XAResource} based transaction management contract.<br/>
 * 
 * The LocalTransactionException is used for the local transaction management
 * contract to indicate the following common error conditions:<br/>
 * <ul>
 *   <li>Invalid transaction context when a transaction operation is executed.
 *   For example, calling commit method on LocalTransaction object without an
 *   active local transaction is an error condition.</li>
 *   <li>Transaction is rolled back instead of getting committed during a commit
 *   method call on the LocalTransaction object.</li>
 *   <li>An attempt to start a local transaction from the same thread on a
 *   {@link ManagedConnection} that is already associated with an active local
 *   transaction.</li>
 *   <li>Any resource adapter or resource manager specific error conditions
 *   related to local transaction management. Examples are violation of integrity
 *   of resources, deadlock detection, communication failure during transaction
 *   completion, retry required or any internal error in a resource manager.</li> 
 * </ul>
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class LocalTransactionException extends ResourceException {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 7495828853103281459L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public LocalTransactionException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public LocalTransactionException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public LocalTransactionException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public LocalTransactionException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public LocalTransactionException(String message, String errorCode) {
        super(message, errorCode);
    }

}
