/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: TestSignature.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.ee.jca;

import org.ow2.spec.testengine.SignatureCompare;
import org.testng.annotations.Test;

/**
 * Test the signature.
 * @author Florent Benoit
 */
public class TestSignature {

    /**
     * This test ensure that the signature of this package is valid
     * @throws Exception if signature is invalid.
     */
    @Test
    public void checkSignature() throws Exception {
        SignatureCompare sig = new SignatureCompare(new String[] { "target/classes", "jca-1.5-ref.xml"});
        sig.check();
    }

}
