/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: NotSupportedException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource;

/**
 * A NotSupportedException is thrown to indicate that callee (resource adapter
 * or application server for system contracts) cannot execute an operation
 * because the operation is not a supported feature. For example, if the
 * transaction support level for a resource adapter is NO_TRANSACTION, an
 * invocation of getXAResource method on a ManagedConnection object should
 * throw a NotSupportedException exception.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class NotSupportedException extends ResourceException {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = -5433838894743521833L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public NotSupportedException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param messagethe detail message.
     */
    public NotSupportedException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public NotSupportedException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public NotSupportedException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public NotSupportedException(String message, String errorCode) {
        super(message, errorCode);
    }

}
