/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResourceException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource;

/**
 * This is the root interface of the exception hierarchy defined for the
 * Connector architecture. The ResourceException provides the following
 * information:
 * <ul>
 * <li>A resource adapter vendor specific string describing the error.
 * This string is a standard Java exception message and is available
 * through getMessage() method.</li>
 *
 * <li>resource adapter vendor specific error code.</li>
 *
 * <li>reference to another exception. Often a resource exception will be
 * result of a lower level problem. If appropriate, this lower level
 * exception can be linked to the ResourceException. Note, this has been
 * deprecated in favor of J2SE release 1.4 exception chaining facility. </li>
 * </ul>
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class ResourceException extends Exception {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 547071213627824490L;

    /**
     * a string specifying the vendor specific error code.
     */
    private String errorCode;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public ResourceException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public ResourceException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type {@link Throwable}.
     */
    public ResourceException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type {@link Throwable}.
     */
    public ResourceException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Create a new throwable with the specified message and error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public ResourceException(String message,
                             String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Set the error code.
     * @param errorCode the error code.
     */
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Get the error code.
     * @return the error code.
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Get the exception linked to this ResourceException
     * @deprecated J2SE release 1.4 supports a chained exception facility that
     * allows any throwable to know about another throwable, if any, that caused
     * it to get thrown. Refer to getCause and initCause methods of the
     * java.lang.Throwable class..
     * @return linked Exception, null if none
     */
    public Exception getLinkedException() {
        return null;
    }

    /**
     * Add a linked Exception to this ResourceException.
     * @deprecated J2SE release 1.4 supports a chained exception facility that allows
     * any throwable to know about another throwable, if any, that caused it to get
     * thrown. Refer to getCause and initCause methods of the java.lang.Throwable class.
     * @param exlinked Exception
     */
    public void setLinkedException(Exception ex) {
        // do nothing
    }

    /**
     * Returns a detailed message string describing this exception.
     * @return a detailed message string.
     */
    public String getMessage() {

        // Prints a nicer message
        String message = super.getMessage();
        String errorCode = getErrorCode();

        StringBuilder sb = new StringBuilder();

        // Prints message (if any)
        if (message != null) {
            sb.append(message);
        }

        // Prints error code (if any)
        if (errorCode != null) {
            // Prints separator if there was a message
            if (message != null) {
                sb.append(", ");
            }
            sb.append("error code: ");
            sb.append(errorCode);
        }

        return sb.toString();
    }
}
