/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Record.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;

import java.io.Serializable;
 
/**
 * The javax.resource.cci.Record interface is the base interface for the
 * representation of an input or output to the execute methods defined
 * on an Interaction.<br/>
 * 
 * The Record interface can be extended to form a one of the following
 * representations:<ul>
 * <li>MappedRecord: A key-value pair based collection represents a
 * record. This interface is based on the java.util.Map</li>
 * <li>IndexedRecord:An ordered and indexed collection represents a
 * record. This interface is based on the java.util.List.</li>
 * <li>JavaBean based representation of an EIS abstraction: An example
 * is a custom record generated to represent a purchase order in an
 * ERP system.</li>
 * <li>javax.resource.cci.ResultSet: This interface extends both
 * java.sql.ResultSet and javax.resource.cci.Record. A ResultSet
 * represents tabular data. </li>
 * <br/>
 * A MappedRecord or IndexedRecord can contain another Record. This
 * means that MappedRecord and IndexedRecord can be used to create a
 * hierarchical structure of any arbitrary depth. A basic Java type
 * is used as the leaf element of a hierarchical structure represented
 * by a MappedRecord or IndexedRecord.
 * @version 0.8
 * @author Guillaume Sauthier
 */
public interface Record extends Cloneable, Serializable {

    /**
     * Gets the name of the Record.
     * @return String representing name of the Record
     */
    String getRecordName();
    
    /**
     * Sets the name of the Record.
     * @param name Name of the Record
     */
    void setRecordName(String name);
    
    /**
     * Sets a short description string for the Record. This property
     * is used primarily by application development tools.
     * @param description String representing a short description of the Record
     */
    void setRecordShortDescription(String description);
    
    /**
     * Gets a short description string for the Record. This property
     * is used primarily by application development tools.
     * @return String representing a short description of the Record
     */
    String getRecordShortDescription();
    
    /**
     * Check if this instance is equal to another Record.
     * {@inheritDoc}
     */
    boolean equals(Object other);
    
    /**
     * {@inheritDoc}
     */
    int hashCode();
    
    /**
     * {@inheritDoc}
     */
    Object clone() throws CloneNotSupportedException;
}
