/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TransactionSupport.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;


/**
 * This interface may be optionally implemented by a ManagedConnectionFactory to provide its level of transaction support at
 * runtime. <br />
 * When a ManagedConnectionFactory implements this interface, the application server uses the TransactionSupportLevel returned by
 * getTransactionSupport() method and not the value specified in the resource adapter deployment descriptor or deployer
 * configuration
 * @since 1.6
 * @author Florent Benoit
 */
public interface TransactionSupport extends java.io.Serializable {

    public enum TransactionSupportLevel {
        /**
         * The resource adapter supports resource manager local transactions by implementing the LocalTransaction interface.
         */
        LocalTransaction,

        /**
         * The resource adapter supports neither resource manager nor JTA transactions.
         */
        NoTransaction,

        /**
         * The resource adapter supports both resource manager local and JTA transactions by implementing the LocalTransaction and
         * XAResource interfaces.
         */
        XATransaction
    }

    /**
     * Get the level of transaction support, supported by the ManagedConnectionFactory. A resource adapter must always return a
     * level of transaction support whose ordinal value in TransactionSupportLevel enum is equal to or lesser than the resource
     * adapter's transaction support classification.
     */
    TransactionSupport.TransactionSupportLevel getTransactionSupport();
}
