/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SecurityContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

/**
 * A standard WorkContext that allows a Work instance to propagate security related context information from an EIS to an
 * application server.
 * <br />
 * This allows an EIS/resource adapter to flow-in security context information and execute a Work instance, and call methods on a
 * MessageEndpoint interface, to effect message inflow, within that Work instance, in the context of an established identity.
 * <br />
 * A resource adapter indicates to the WorkManager, that a Work instance needs to be run in a specified security execution context
 * by submitting a Work instance that implements WorkContextProvider interface and ensuring that the List of WorkContexts for that
 * Work instance contains an instance of its subclass of Securitytext.
 * <br />
 * It should be noted however that when a resource adapter flows-in an identity to be used by the application server, the
 * propagated identity may or may not belong to the application server's security domain.
 * <br />
 * There are therefore, two scenarios while a resource adapter propagates a security identity from an EIS to the application
 * server:
 * <br />
 * Case 1: Resource adapter flows-in an identity in the application server's security domain: In this case, the application server
 * could just set the initiating principal, flown-in from the resource adapter, as the security context the Work instance executes
 * as. Case 2: Resource adapter flows-in an identity belonging to the EIS' security domain: The resource adapter establishes a
 * connection to the EIS and needs to perform a Work in the context of an EIS identity. In this case, the initiating or caller
 * principal does not exist in the application server's security domain and a translation from one domain to the other needs to be
 * performed.
 * @since 1.6
 * @author Florent Benoit
 */
public abstract class SecurityContext implements WorkContext {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 7730296651802712658L;

    /**
     * Constructs a new TransactionContext.
     */
    public SecurityContext() {

    }

    /**
     * Get the brief description of the role played by the WorkContext and any other related debugging information.
     */
    public String getDescription() {
        return SecurityContext.class.getName();
    }

    /**
     * Get the associated name of the WorkContext.
     */
    public String getName() {
        return SecurityContext.class.getName();
    }
    
    /**
     *  The container calls this method to set up the security Context for the Work instance.
     */
    public abstract void setupSecurityContext(CallbackHandler handler, Subject executionSubject, Subject serviceSubject);


}
