/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkAdapter.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This class is provided as a convenience for easily creating
 * {@link WorkListener} instances by extending this class and
 * overriding only those methods of interest.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class WorkAdapter implements WorkListener {

    /**
     * {@inheritDoc}
     * @see javax.resource.spi.work.WorkListener#workAccepted(javax.resource.spi.work.WorkEvent)
     */
    public void workAccepted(WorkEvent e) { }
 
    /**
     * {@inheritDoc}
     * @see javax.resource.spi.work.WorkListener#workCompleted(javax.resource.spi.work.WorkEvent)
     */
    public void workCompleted(WorkEvent e) { }

    /**
     * {@inheritDoc}
     * @see javax.resource.spi.work.WorkListener#workRejected(javax.resource.spi.work.WorkEvent)
     */
    public void workRejected(WorkEvent e) { }

    /**
     * {@inheritDoc}
     * @see javax.resource.spi.work.WorkListener#workStarted(javax.resource.spi.work.WorkEvent)
     */
    public void workStarted(WorkEvent e) { }

}
