/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkContextErrorCodes.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This class models the possible error conditions that might occur during associating an WorkContext with a Work instance.
 * <br />
 * This class is not designed as an Enumerated type (Enum), as the error codes listed below could be expanded to accommodate
 * custom error conditions for custom WorkContext types.
 * @since 1.6
 * @author Florent Benoit
 */
public class WorkContextErrorCodes {

    /**
     * Indicates that a WorkContext type, that was not specified as optional, passed in by the Work instance is not supported by the container. 
     */
    public static final String UNSUPPORTED_CONTEXT_TYPE = "1";
    
    /**
     * Indicates that there are more than one instance of a WorkContext type passed in by the Work instance. 
     */
    public static final String DUPLICATE_CONTEXTS = "2";
    
    /**
     * Indicates a failure in recreating the WorkContext instance. For TransactionContext instances, the WorkManager must use this failure code when it should have used WorkException#TX_RECREATE_FAILED as the error code. 
     */
    public static final String CONTEXT_SETUP_FAILED = "3";
    
    /**
     * Indicates that the container cannot support recreating the WorkContext instance. For TransactionContext instances, the WorkManager must use this failure code when it should have used WorkException#TX_CONCURRENT_WORK_DISALLOWED as the error code. 
     */
    public static final String CONTEXT_SETUP_UNSUPPORTED = "4";
}
