/**
 * EasyBeans
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EJBContainerProvider.java 6008 2011-10-17 13:41:22Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.ejb.spi;

import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;

/**
 * The EJBContainerProvider SPI is used by the embeddable container bootstrap class to initialize a suitable embeddable container.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=318">EJB 3.1 specification</a>
 * @author Florent Benoit
 * @since EJB 3.1 version.
 */

public interface EJBContainerProvider {

    /**
     * Called by the embeddable container bootstrap process to find a suitable embeddable container implementation. An embeddable
     * container provider may deem itself as appropriate for the embeddable application if any of the following are true : The
     * javax.ejb.embeddable.initial property was included in the Map passed to createEJBContainer and the value of the property is
     * the provider's implementation class. No javax.ejb.embeddable.initial property was specified. If a provider does not qualify
     * as the provider for the embeddable application, it must return null.
     * @return EJBContainer instance or null
     * @throws EJBException if container is not created.
     */
    EJBContainer createEJBContainer(java.util.Map<?, ?> properties) throws EJBException;
}
