/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InterceptorBinding.java 5349 2010-02-17 14:40:34Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.interceptor;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Specifies that an annotation type is an interceptor binding type.
 * 
 * <pre>
 *  &#064;Inherited
 *  &#064;InterceptorBinding
 *  &#064;Target({TYPE, METHOD})
 *  &#064;Retention(RUNTIME)
 *  public &#064;interface Valid {}
 * </pre>
 *  
 * Interceptor bindings are intermediate annotations that may be used to associate interceptors
 * with target beans.
 *  
 * The interceptor bindings of an interceptor are specified by annotating the interceptor class
 * with the binding types and &#064;Interceptor.
 * <pre>
 *  &#064;Valid &#064;Interceptor
 *  public class ValidationInterceptor { ... }
 * </pre>
 * 
 * An interceptor may specify multiple interceptor bindings.
 * 
 * An interceptor binding of a bean may be declared by annotating the bean class, or a method of
 * the bean class, with the interceptor binding type.
 * <pre>
 *  &#064;Valid
 *  public class Order { ... }
 * 
 *  &#064;Valid &#064;Secure
 *  public void updateOrder(Order order) { ... }
 * </pre>
 * 
 * A bean class or method of a bean class may declare multiple interceptor bindings.
 * 
 * An interceptor binding type may declare other interceptor bindings.
 * <pre>
 *  &#064;Inherited
 *  &#064;InterceptorBinding
 *  &#064;Target({TYPE, METHOD})
 *  &#064;Retention(RUNTIME)
 *  &#064;Valid
 *  public &#064;interface Secure {}
 * </pre>
 * 
 * Interceptor bindings are transitive : an interceptor binding declared by an interceptor binding
 * type is inherited by all beans and other interceptor binding types that declare that interceptor
 * binding type.
 * 
 * @author Guillaume Sauthier
 * @see Interceptor
 * @since Interceptor 1.1 version.
 */
@Target(ANNOTATION_TYPE)
@Retention(RUNTIME)
@Documented
public @interface InterceptorBinding {}

