/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuthStatus.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message;

/**
 * The AuthStatus class is used to represent return values from Authentication
 * modules and Authentication Contexts. An AuthStatus value is returned when
 * the module processing has established a corresponding request or response
 * message within the message parameters exchanged with the runtime.
 *
 * @version 1.0
 */
public class AuthStatus {
    /**
     * Indicates that the message processing by the authentication module
     * was successful and that the runtime is to proceed with its normal
     * processing of the resulting message.
     */
    public static final AuthStatus SUCCESS = new AuthStatus(1);

    /**
     * Indicates that the message processing by the authentication module
     * was NOT successful, and that the module replaced the application
     * message with an error message.
     */
    public static final AuthStatus FAILURE = new AuthStatus(2);

    /**
     * Indicates that the message processing by the authentication module
     * was successful and that the runtime is to proceed by sending
     * a message returned by the authentication module.
     */
    public static final AuthStatus SEND_SUCCESS = new AuthStatus(3);

    /**
     * Indicates that the message processing by the authentication module
     * was NOT successful, that the module replaced the application
     * message with an error message, and that the runtime is to proceed
     * by sending the error message.
     */
    public static final AuthStatus SEND_FAILURE = new AuthStatus(4);

    /**
     * Indicates the message processing by the authentication module
     * is NOT complete, that the module replaced the application
     * message with a security message, and that the runtime is to proceed
     * by sending the security message.
     */
    public static final AuthStatus SEND_CONTINUE = new AuthStatus(5);

    /**
     * The internal value.
     */
    private int value;

    /**
     * Private zero-argument constructor: value is initialized at SUCCESS.
     */
    private AuthStatus() {
        this.value = 1;
    }

    /**
     * Private constructor to differentiate AuthStatuses with an internal value.
     * @param aValue The internal value
     */
    private AuthStatus(int aValue) {
        this.value = aValue;
    }
}
