/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupPrincipalCallback.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.callback;

import javax.security.auth.Subject;

/**
 * Callback establishing group principals within the argument subject.
 * This callback is intended to be called by a <code>serverAuthModule</code>
 * during its <code>validateRequest</code> processing.
 *
 * @version 1.0
 */
public class GroupPrincipalCallback implements javax.security.auth.callback.Callback {
    private static final long serialVersionUID = -7557212296842690793L;

    /**
     * The subject to be MODIFIED BY the callback handler.
     */
    private Subject theSubject;

    /**
     * The list of group names to be added TO the subject BY the handler.
     * The callback handler is responsible for creating the group principals (of
     * a Principal type of its choice).
     */
    private String[] theGroups;


    /**
     * Create a GroupPrincipalCallback to establish the container's
     * representation of the corresponding group principals within
     * the Subject.
     *
     * @param s The Subject in which the container will create
     * group principals.
     *
     * @param g An array of Strings, where each element contains
     * the name of a group that will be used to create a
     * corresponding group principal within the Subject.
     * <p />
     * When a null value is passed to the g argument, the handler will
     * establish the container's representation of no group principals within
     * the Subject.
     * Otherwise, the handler's processing of this callback is
     * additive, yielding the union (without duplicates) of the principals
     * existing within the Subject, and those created with the names occuring
     * within the argument array. The CallbackHandler will define the type
     * of the created principals.
     */
    public GroupPrincipalCallback(Subject s, String[] g) {
        this.theSubject = s;
        this.theGroups = g;
    }

    /**
     * Get the Subject in which the handler will establish the
     * group principals.
     *
     * @return The subject.
     */
    public Subject getSubject() {
        return theSubject;
    }

    /**
     * Get the array of group names.
     *
     * @return Null, or an array containing 0 or more String group names.
     * <p />
     * When the return value is null, the handler will
     * establish the container's representation of no group principals within
     * the Subject.
     *
     * Otherwise, the handler's processing of this callback is
     * additive, yielding the union (without duplicates) of the principals
     * created with the names in the returned array and those existing
     * within the Subject.
     */
    public String[] getGroups() {
        return theGroups;
    }

}
