/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RegistrationListener.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.config;

/**
 * An implementation of this interface may be associated with an
 * AuthConfigProvider registration at an AuthConfigFactory at the
 * time the AuthConfigProvider is obtained for use from the factory.
 * The AuthConfigFactory will invoke the notify
 * method of the RegistrationListener if the corresponding provider
 * registration is unregistered or replaced at the factory.
 */
public interface RegistrationListener {

    /**
     * Notify the listener that a registration with which it was
     * associated was replaced or unregistered.
     *
     * <p />
     *
     * When a RegistrationListener is associated with a provider
     * registration within the factory, the factory must call its
     * <code>notify</code> method when the corresponding registration
     * is unregistered or replaced.

     * @param layer A String identifying the one or more message layers
     * corresponding to the registration for which the listener is being
     * notified.
     *
     * @param appContext A String value identifying the application
     * contexts corresponding to the registration for which the listener is
     * being notified.
     *
     * The factory detaches the listener from the corresponding
     * registration once the listener has been notified for the
     * registration.
     *
     * The <code>detachListener</code> method
     * must be called to detach listeners that are no longer in use.
     */
    public void notify(String layer, String appContext);

}
