/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerAuthContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.config;

import javax.security.auth.message.ServerAuth;

/**
 * This ServerAuthContext class encapsulates ServerAuthModules that are used
 * to validate service requests received from clients, and to secure any
 * response returned for those requests.  A caller typically uses this class
 * in the following manner:
 *
 * <ol>
 * <li> Retrieve an instance of this class via
 *      ServerAuthConfig.getAuthContext.</li>
 * <li> Invoke <i>validateRequest</i>.
 *      <br />
 *	ServerAuthContext implementation invokes validateRequest of
 *      one or more encapsulated
 *	ServerAuthModules.  Modules validate credentials present in request
 *	(for example, decrypt and verify a signature).</li>
 * <li> If credentials valid and sufficient, authentication complete.
 *      <br />
 *      Perform authorization check on authenticated identity and,
 *	if successful, dispatch to requested service application.</li>
 * <li> Service application finished.</li>
 * <li> Invoke <i>secureResponse</i>.
 *      <br />
 *	ServerAuthContext implementation invokes secureResponse of
 *      one or more encapsulated
 *	ServerAuthModules.  Modules secure response
 *	(sign and encrypt response, for example), and prepare response message.</li>
 * <li> Send secured response to client.</li>
 * <li> Invoke <i>cleanSubject</i> (as necessary)
 *	to clean up any authentication state in Subject(s).</li>
 * </ol>
 *
 * <p />
 *
 * A ServerAuthContext instance may be used concurrently by multiple
 * callers.
 *
 * <p />
 *
 * Implementations of this interface are responsible for constructing
 * and initializing the encapsulated modules.  The initialization step
 * includes passing the relevant request and response MessagePolicy objects
 * to the encapsulated modules. The MessagePolicy objects are obtained
 * by the ServerAuthConfig instance used to obtain the ServerAuthContext
 * object.
 * See <code>ServerAuthConfig.getAuthContext</code> for more information.
 *
 * <p />
 *
 * Implementations of this interface are instantiated by their associated
 * configuration object such that they know which modules to invoke, in what
 * order, and how results returned by preceding modules are to influence
 * subsequent module invocations.
 *
 * <p />
 *
 * Calls to the inherited methods of this interface delegate to the
 * corresponding methods of the encapsulated authentication modules.
 *
 * @version 1.0
 * @see ServerAuthConfig
 * @see ServerAuthModule
 */
public interface ServerAuthContext extends ServerAuth {

}
