/**
 * OW2 Specifications
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 5871 2011-05-05 12:11:35Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.ee.jaxrs;

import javax.ws.rs.ext.RuntimeDelegate;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * A {@code Activator} is responsible to manage the life-cycle of the
 * proxy RuntimeDelegate that handles RuntimeDelegate services dynamics.
 *
 * @author Guillaume Sauthier
 */
public class Activator implements BundleActivator {

    /**
     * RuntimeDelegate proxy.
     */
    private ForwardingRuntimeDelegate delegate;

    public void start(final BundleContext context) throws Exception {

        // Create and register our delegate
        this.delegate = new ForwardingRuntimeDelegate(context);
        RuntimeDelegate.setInstance(delegate);

        // Start services management
        this.delegate.start();
    }

    public void stop(final BundleContext context) throws Exception {

        // Stop services management
        this.delegate.stop();

        // Nullify references
        this.delegate = null;
        RuntimeDelegate.setInstance(null);
    }

}
