/**
 * Copyright 2013 ScalAgent Distributed Technologies
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  ---------------------------------------------------------------------
 *  $Id: TopicRequestor.java 6347 2013-03-13 08:52:02Z tachker $
 *  ---------------------------------------------------------------------
 */

package javax.jms;

public class TopicRequestor {
  private TopicSession session;
  private TemporaryTopic temporaryTopic;
  private TopicPublisher publisher;
  private TopicSubscriber subscriber;

  public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
    if (topic == null)
      throw new InvalidDestinationException("Invalid topic");
    this.session = session;
    temporaryTopic = session.createTemporaryTopic();
    publisher = session.createPublisher(topic);
    subscriber = session.createSubscriber(temporaryTopic);
  }

  public Message request(Message message) throws JMSException {
    message.setJMSReplyTo(temporaryTopic);
    publisher.publish(message);
    return subscriber.receive();
  }

  public void close() throws JMSException {
    session.close();
    temporaryTopic.delete();
  }
}
