/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OptimisticLockException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * The OptimisticLockException is thrown by the persistence provider when an
 * optimistic locking conflict occurs. This exception may be thrown as part of
 * an API call, at flush, or at commit time. The current transaction, if one is
 * active, will be marked for rollback.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=220">EJB 3.0 specification</a>
 * @author Florent Benoit
 * @since EJB 3.0 version.
 */
public class OptimisticLockException extends PersistenceException {

    /**
     * UID for serialization.
     */
    private static final long serialVersionUID = 4897155239605045768L;

    /**
     * Entity.
     */
    // TODO: Well, it seems that it is not private in the spec, That's bad !
    Object entity = null;

    /**
     * Default constructor : builds an exception with an empty message.
     */
    public OptimisticLockException() {
        super();
    }

    /**
     * Build an exception with the given message.
     * @param message the given message to use.
     */
    public OptimisticLockException(final String message) {
        super(message);
    }

    /**
     * Build an exception with the given exception.
     * @param causedByThrowable the cause of this exception.
     */
    public OptimisticLockException(final Throwable causedByThrowable) {
        super(causedByThrowable);
    }

    /**
     * Builds an exception with a given message and given exception.
     * @param message the message of this exception.
     * @param causedByThrowable the cause of this exception.
     */
    public OptimisticLockException(final String message, final Throwable causedByThrowable) {
        super(message, causedByThrowable);
    }

    /**
     * Build an exception with the given entity.
     * @param entity the given entity to use.
     */
    public OptimisticLockException(final Object entity) {
        super();
        this.entity = entity;
    }

    /**
     * Builds an exception with a given message and given exception.
     * @param message the message of this exception.
     * @param causedByThrowable the cause of this exception.
     * @param entity the given entity to use.
     */
    public OptimisticLockException(final String message, final Throwable causedByThrowable, final Object entity) {
        super(message, causedByThrowable);
        this.entity = entity;
    }

    /**
     * Gets the entity object.
     * @return the entity object.
     */
    public Object getEntity() {
        return this.entity;
    }

}
