/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Attribute.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence.metamodel;

/**
 * Represents an attribute of a Java type.
 * @param <X> The represented type that contains the attribute
 * @param <Y> The type of the represented attribute
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public interface Attribute<X, Y> {
    public static enum PersistentAttributeType {
        MANY_TO_ONE, ONE_TO_ONE, BASIC, EMBEDDED, MANY_TO_MANY, ONE_TO_MANY, ELEMENT_COLLECTION
    }

    /**
     * Return the name of the attribute.
     * @return name
     */
    String getName();

    /**
     * Return the persistent attribute type for the attribute.
     * @return persistent attribute type
     */
    PersistentAttributeType getPersistentAttributeType();

    /**
     * Return the managed type representing the type in which the attribute was declared.
     * @return declaring type
     */
    ManagedType<X> getDeclaringType();

    /**
     * Return the Java type of the represented attribute.
     * @return Java type
     */
    Class<Y> getJavaType();

    /**
     * Return the java.lang.reflect.Member for the represented attribute.
     * @return corresponding java.lang.reflect.Member
     */
    java.lang.reflect.Member getJavaMember();

    /**
     * Is the attribute an association.
     * @return boolean indicating whether the attribute corresponds to an association
     */
    boolean isAssociation();

    /**
     * Is the attribute collection-valued (represents a Collection, Set, List, or Map).
     * @return boolean indicating whether the attribute is collection-valued
     */
    boolean isCollection();
}
