/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JCAConnectionStats.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee.statistics;
 
/**
 * Specifies the statistics provided by a JCA connection.
 * @author Guillaume Sauthier
 */
public interface JCAConnectionStats extends Stats {

    /**
     * Returns the associated JCAConnectionFactory OBJECT_NAME.
     * @return String the OBJECT_NAME of the managed object that
     *         identifies the connection factory for this connection
     */
    String getConnectionFactory();
    
    /**
     * Returns the associated JCAManagedConnectionFactory OBJECT_NAME.
     * @return String the OBJECT_NAME of the managed object that
     *         identifies the managed connection factory for this connection
     */
    String getManagedConnectionFactory();
    
    /**
     * Returns the time spent waiting for a connection to be available.
     * @return TimeStatistic
     */
    TimeStatistic getWaitTime();
    
    /**
     * Returns the time spent using a connection
     * @return TimeStatistic
     */
    TimeStatistic getUseTime();
}
