/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SignatureResultSet.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.testengine;

import java.util.ArrayList;
import java.util.List;

/**
 * Collect all error reports.
 * @author Guillaume Sauthier
 */
public class SignatureResultSet {

    /**
     * The compliance errors.
     */
    List<ComparisonError> errors;

    /**
     * Construct a new {@link SignatureResultSet}.
     */
    public SignatureResultSet() {
        errors = new ArrayList<ComparisonError>();
    }

    /**
     * Add a {@link ComparisonError} in the list.
     * @param error the error to add
     */
    public void addError(ComparisonError error) {
        errors.add(error);
    }

    /**
     * Returns true if this set has errors inside.
     * @return
     */
    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        int total = errors.size();
        sb.append(total + " errors.");

        int index = 0;
        for (ComparisonError error : errors) {
            sb.append("\n-----------------------------------------------------\n");
            sb.append("Error " + index + " :\n");
            sb.append(error.toString());
            index++;
        }

        return sb.toString();
    }

}
