/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AnnotationMetadata.java 5276 2010-01-08 16:22:04Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.testengine.metadata;

import java.util.ArrayList;
import java.util.List;

import org.ow2.spec.testengine.SignatureResultSet;

public class AnnotationMetadata  extends AbsMetadata {

    private String desc = null;

    private boolean visible = false;

    private List<EnumAnnotationMetadata> enumAnnotationMetadataList = null;


    public AnnotationMetadata(String desc, boolean visible) {
        this.desc = desc;
        this.visible = visible;
        this.enumAnnotationMetadataList = new ArrayList<EnumAnnotationMetadata>();
    }

    public void addEnumAnnotationMetadata(EnumAnnotationMetadata enumAnnotationMetadata) {
        enumAnnotationMetadataList.add(enumAnnotationMetadata);
    }

    public String getName() {
        return desc;
    }

    public void compare(AnnotationMetadata other, SignatureResultSet rs) {
        // compare desc
        compare(getName() + " desc", desc, other.desc, rs);

        // compare visible
        compare(getName() + " visible", visible, other.visible, rs);

        // compare enum
        compareList(getName() + " enum", enumAnnotationMetadataList, other.enumAnnotationMetadataList, rs);



    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AnnotationMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((AnnotationMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }


    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        String newIndent = indent + "  ";

        sb.append("\n");
        sb.append(indent);
        sb.append("<annotation");

        // attributes

        // desc Attribute
        addObjectToSB("desc", desc, sb);

        // visible Attribute
        addObjectToSB("visible", visible, sb);


        // enum-annotations
        if (enumAnnotationMetadataList.size()> 0) {
            sb.append(">");

            // exceptions
            addListToSB(enumAnnotationMetadataList, sb, newIndent);

            // end element
            sb.append("\n");
            sb.append(indent);
            sb.append("</annotation>");
        } else {
            // close element directly
            sb.append(" />");

        }

        return sb.toString();
    }

}
