/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagedBean.java 5347 2010-02-17 14:28:59Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.annotation;

import static java.lang.annotation.ElementType.TYPE;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>The ManagedBean annotation marks a POJO (Plain Old Java Object) as a ManagedBean.</p>
 * 
 * <p>A ManagedBean supports a small set of basic services such as resource injection,
 * lifecycle callbacks and interceptors.</p> 

 * @author Guillaume Sauthier
 * @since Commons Annotations 1.1.
 */
@Target(TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ManagedBean {

    /**
     * <p>The name of the Managed Bean.</p>
     * 
     * <p>Managed Bean names must be unique within a Java EE module.</p>
     * 
     * <p>For each named Managed Bean, Java EE containers must make available the
     * following entries in {@code JNDI}, using the same naming scheme used for EJB components.</p>
     * 
     * <p>In the application namespace: {@code java:app/<module-name>/<bean-name>}</p>
     * 
     * <p>In the module namespace of the module containing the Managed Bean: {@code java:module/<bean-name>}</p> 
     */
    String value() default "";

}
