/**
 * EasyBeans
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DataSourceDefinitions.java 6166 2012-02-09 14:18:49Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.annotation.sql;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The DataSource annotation is used to declare a container DataSource. Since repeated annotations are not allowed, the
 * DataSourceDefinitions annotation acts as a container for multiple data source declaration.
 * @see <a href="http://jcp.org/en/jsr/detail?id=250">Annotation 1.1 specification</a>
 * @author Florent Benoit
 * @since Annotation 1.1 version.
 */
@Target( { TYPE })
@Retention(RUNTIME)
public @interface DataSourceDefinitions {

    /**
     * Container for defining multiple data sources.
     */
    DataSourceDefinition[] value();
}
