/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Qualifier.java 5374 2010-02-25 17:22:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.inject;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Identifies qualifier annotations. Anyone can define a new qualifier. A qualifier annotation:
 * <ul>
 *  <li>is annotated with @Qualifier, @Retention(RUNTIME), and typically @Documented.</li>
 *  <li>can have attributes.</li>
 *  <li>may be part of the public API, much like the dependency type, but unlike implementation types
 *      which needn't be part of the public API.</li>
 *  <li>may have restricted usage if annotated with @Target. While this specification covers applying
 *      qualifiers to fields and parameters only, some injector configurations might use qualifier
 *      annotations in other places (on methods or classes for example).</li>
 * </ul>
 *
 * For example:
 * <pre>
 *  &#064;Documented
 *  &#064;Retention(RUNTIME)
 *  &#064;Qualifier
 *  public @interface Leather {
 *    Color color() default Color.TAN;
 *    public enum Color { RED, BLACK, TAN }
 *  }
 * </pre>
 *
 * @see javax.inject.Named
 * @author Guillaume Sauthier
 * @since DI 1.0
 */
@Target(ANNOTATION_TYPE)
@Retention(RUNTIME)
@Documented
public @interface Qualifier {}
