/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Delegate.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.decorator;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Identifies the delegate injection point of a decorator. May be applied to a field, bean constructor
 * parameter or initializer method parameter of a decorator bean class.
 *
 * <pre>
 *  &#064;Decorator
 *  class TimestampLogger implements Logger {
 *    &#064;Inject @Delegate @Any Logger logger;
 *    ...
 *  }
 *
 *  &#064;Decorator
 *  class TimestampLogger implements Logger {
 *    private Logger logger;
 *    &#064;Inject
 *    public TimestampLogger(@Delegate @Debug Logger logger) {
 *      this.logger = logger;
 *    }
 *    ...
 *  }
 * </pre>
 *
 * A decorator must have exactly one delegate injection point. The delegate injection point must be an
 * injected field, initializer method parameter or bean constructor method parameter.
 *
 * The container injects a delegate object to the delegate injection point. The delegate object
 * implements the delegate type and delegates method invocations along the decorator stack. When the
 * container calls a decorator during business method interception, the decorator may invoke any method
 * of the delegate object. If a decorator invokes the delegate object at any other time, the invoked method
 * throws an IllegalStateException.
 *
 * <pre>
 *  &#064;Decorator
 *  class TimestampLogger implements Logger {
 *    &#064;Inject @Delegate @Any Logger logger;
 *
 *    void log(String message) {
 *      logger.log(timestamp() + ": " + message);
 *    }
 *    ...
 *  }
 * </pre>

 * @author Guillaume Sauthier
 *
 * @since CDI 1.0
 *
 */
@Target({FIELD, PARAMETER})
@Retention(RUNTIME)
@Documented
public @interface Delegate {}