/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CreationalContext.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context.spi;

/**
 * Provides operations that are used by the {@link Contextual} implementation
 * during instance creation and destruction.
 *
 * @author Guillaume Sauthier
 */
public interface CreationalContext<T> {

    /**
     * Registers an incompletely initialized contextual instance the with the container. A
     * contextual instance is considered incompletely initialized until it is returned by
     * {@link Contextual#create(CreationalContext)}.
     * 
     * @param incompleteInstance the incompletely initialized instance
     */
    void push(T incompleteInstance);

    /**
     * Destroys all dependent objects of the instance which is being destroyed, by passing
     * each dependent object to {@link Contextual#destroy(Object, CreationalContext)}.
     */
    void release();
}
