/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: package-info.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

/**
 * The portable extension integration SPI.
 *
 * A portable extension may integrate with the container by:
 * <ul>
 *  <li>Providing its own beans, interceptors and decorators to the container</li>
 *  <li>Injecting dependencies into its own objects using the dependency injection service</li>
 *  <li>Providing a context implementation for a custom scope</li>
 *  <li>Augmenting or overriding the annotation-based metadata with metadata from some other source</li>
 * </ul>
 *
 * <h1>The {@code BeanManager} object</h1>
 *
 * Portable extensions sometimes interact directly with the container via programmatic API
 * call. The interface {@link javax.enterprise.inject.spi.BeanManager} provides operations for obtaining contextual references for beans, along with many other operations of use to portable extensions.
 *
 * <h1>Container life-cycle events</h1>
 *
 * During the application initialization process, the container fires a series of events, allowing portable extensions to integrate with the container initialization process. Observer methods of these events must belong to extensions declared in META-INF/services.
 *
 * Life-cycle events include BeforeBeanDiscovery, AfterBeanDiscovery, AfterDeploymentValidation and BeforeShutdown.
 *
 * <h1>Interfaces representing enabled beans</h1>
 *
 * The interfaces Bean, Decorator, Interceptor and ObserverMethod define everything the container needs to manage instances of a bean, interceptor, decorator or observer method.
 *
 * An instance of Bean exists for every enabled bean. A portable extension may add support for new kinds of beans by implementing Bean, observing the event AfterBeanDiscovery event registering beans with the container. An instance of ObserverMethod exists for every observer method of every enabled bean. A portable extension may add observers by implementing ObserverMethod and registering an instance with the container.
 *
 * A portable extension may be notified of the existence of an enabled bean by observing the container lifecycle event type ProcessBean or one of its subtypes, or of the existence of an observer method of an enabled bean by observing the event type ProcessObserverMethod.
 *
 * <h1>Alternate metadata sources</h1>
 *
 * A portable extension may provide an alternative metadata source, such as configuration by XML.
 *
 * Annotated and its subtypes allow a portable extension to specify metadata that overrides the annotations that exist on a bean class. The portable extension is responsible for implementing the interfaces, thereby exposing the metadata to the container. The container must use the operations of Annotated and its subinterfaces to discover program element types and annotations, instead of directly calling the Java Reflection API.
 *
 * A portable extension provides its metadata to the container by observing the event ProcessAnnotatedType and wrapping the AnnotatedType.
 *
 * <h1>Producer and InjectionTarget</h1>
 *
 * The interfaces Producer and InjectionTarget abstract the basic life-cycle of (contextual or non-contextual) container managed objects, including instantiation and destruction, dependency injection and lifecycle callbacks.
 *
 * An instance of InjectionTarget may be obtained from the BeanManager, allowing a portable extension to request these container services for objects under the control of the portable extension.
 *
 * Furthermore, a portable extension may replace the implementation of InjectionTarget or Producer used by the container with its own implementation by observing the events ProcessInjectionTarget or ProcessProducer.
 *
 * @see javax.enterprise.inject
 * @see javax.enterprise.context.spi
 */
package javax.enterprise.inject.spi;