/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LazyAssociatableConnectionManager.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * This is a mix-in interface that may be optionally implemented by a
 * ConnectionManager implementation. An implementation of this interface
 * must support the lazy connection association optimization.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface LazyAssociatableConnectionManager {

    /**
     * This method is called by a resource adapter (that is capable of
     * lazy connection association optimization) in order to lazily
     * associate a connection object with a ManagedConnection instance.
     * @param connection the connection object that is to be associated.
     * @param mcf The ManagedConnectionFactory instance that was originally
     *        used to create the connection object.
     * @param cxReqInfo connection request information. This information
     *        must be the same as that used to originally create the connection
     *        object.
     * @throws ResourceException Generic exception.
     * @throws ApplicationServerInternalException Application server specific
     *         exception.
     * @throws SecurityException Security related error.
     * @throws ResourceAllocationException Failed to allocate system resources
     *         for connection request.
     * @throws ResourceAdapterInternalException Resource adapter related
     *         error condition.
     */
    void associateConnection(Object connection,
                             ManagedConnectionFactory mcf,
                             ConnectionRequestInfo cxReqInfo)
         throws ResourceException;
}
