/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkRejectedException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;
 
/**
 * This exception is thrown by a WorkManager to indicate that a submitted
 * Work instance has been rejected. The rejection could be due to internal
 * factors or start timeout expiration.<br/>
 * 
 * This could be thrown only before the execution of a Work instance
 * starts (that is, before a thread has been allocated for Work execution).<br/>
 * 
 * An associated error code indicates the nature of the error condition.
 * Possible error codes are <code>WorkException.START_TIMED_OUT</code>,
 * <code>WorkException.INTERNAL</code> or <code>WorkException.UNDEFINED</code>.
 * @version 1.0 
 * @author Guillaume Sauthier
 */
public class WorkRejectedException extends WorkException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -687129544691878081L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public WorkRejectedException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public WorkRejectedException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public WorkRejectedException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public WorkRejectedException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public WorkRejectedException(String message, String errorCode) {
        super(message, errorCode);
    }

}
