/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionSpec.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;
 
/**
 * ConnectionSpec is used by an application component to pass connection
 * request-specific properties to the ConnectionFactory. getConnection
 * method.<br/>
 * 
 * It is recommended that the ConnectionSpec interface be implemented
 * as a JavaBean to support tools. The properties on the ConnectionSpec
 * implementation class must be defined through the getter and setter
 * methods pattern.<br/>
 * 
 * The CCI specification defines a set of standard properties for an
 * ConnectionSpec. The properties are defined either on a derived
 * interface or an implementation class of an empty ConnectionSpec
 * interface. In addition, a resource adapter may define additional
 * properties specific to its underlying EIS. 
 * @version 1.0 Public Draft 1
 * @author Guillaume Sauthier
 */
public interface ConnectionSpec {

}
