/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ActivationSpec.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
 
package javax.resource.spi;

/**
 * This interface serves as a marker. An instance of an ActivationSpec must
 * be a JavaBean and must be serializable. This holds the activation
 * configuration information for a message endpoint.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface ActivationSpec extends ResourceAdapterAssociation {

    /**
     * This method may be called by a deployment tool to validate the overall
     * activation configuration information provided by the endpoint deployer.
     * This helps to catch activation configuration errors earlier on without
     * having to wait until endpoint activation time for configuration
     * validation. The implementation of this self-validation check behavior
     * is optional.
     * @throws InvalidPropertyException indicates invalid configuration
     *         property settings.
     */
    void validate() throws InvalidPropertyException;
}
