/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConfigProperty.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Designates a JavaBean property as a configuration property.
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target( { FIELD, METHOD })
@Retention(RUNTIME)
public @interface ConfigProperty {

    /**
     * Inferred by the container if unspecified.
     */
    Class type() default Object.class;

    /**
     * Describes the configuration property.
     */
    String[] description() default {};

    /**
     * Inferred by the container for field based annotations if possible.
     */
    String defaultValue() default "";

    /**
     * Inferred by the container if unspecified.
     */
    boolean ignore() default false;

    /**
     * Indicates that the configuration property supports dynamic updates to its value during the lifetime of the JavaBean.
     */
    boolean supportsDynamicUpdates() default false;

    /**
     * Indicates that the configuration property is confidential and recommends application server's configuration tools to use
     * special visual aids for editing them.
     */
    boolean confidential() default false;

}
