/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionDefinition.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Defines a set of connection interfaces and classes pertaining to a particular connection type. This annotation can be placed
 * only on a JavaBean that implements the ManagedConnectionFactory interface.
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target(TYPE)
@Retention(RUNTIME)
public @interface ConnectionDefinition {

    /**
     * Specifies the ConnectionFactory interface supported by the resource adapter. Example: javax.resource.cci.ConnectionFactory
     * or com.wombat.ConnectionFactory.
     */
    Class connectionFactory();

    
    /**
     * Specifies the Class provided by the resource adapter that implements the resource adapter specific ConnectionFactory interface. Example: com.wombat.ConnectionFactoryImpl.
     */
    Class connectionFactoryImpl();
    
    
    /**
     * Specifies the Connection interface supported by the resource adapter. Example: javax.resource.cci.Connection or com.wombat.Connection.
     */
    Class connection();

    /**
     * Specifies the class provided by the resource adapter that implements the resource adapter specific Connection interface. Example: com.wombat.ConnectionImpl 
     */
    Class connectionImpl();

}
