/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionRequestInfo.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;
 
/**
 * The ConnectionRequestInfo interface enables a resource adapter
 * to pass its own request specific data structure across the
 * connection request flow. A resource adapter extends the empty
 * interface to supports its own data structures for connection
 * request.<br/>
 * 
 * A typical use allows a resource adapter to handle application
 * component specified per-connection request properties (example
 * - client ID, language). The application server passes these
 * properties back across to match/createManagedConnection calls
 * on the resource adapter. These properties remain opaque to the
 * application server during the connection request flow.<br/>
 * 
 * Once the ConnectionRequestInfo reaches match/createManagedConnection
 * methods on the ManagedConnectionFactory instance, resource adapter
 * uses this additional per-request information to do connection
 * creation and matching.
 * @version 0.8
 * @author Guillaume Sauthier
 */
public interface ConnectionRequestInfo {

    /**
     * Checks whether this instance is equal to another. Since
     * connectionRequestInfo is defined specific to a resource
     * adapter, the resource adapter is required to implement
     * this method. The conditions for equality are specific
     * to the resource adapter.
     * @return True if the two instances are equal.
     * {@inheritDoc}
     */
    boolean equals(Object other);
    
    /**
     * Returns the hashCode of the ConnectionRequestInfo.
     * @return hash code of this instance
     * {@inheritDoc}
     */
    int hashCode();
}
