/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DissociatableManagedConnection.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;
 
import javax.resource.ResourceException;

/**
 * This is a mix-in interface that may be optionally implemented by a
 * ManagedConnection implementation. An implementation of this interface
 * must support the lazy connection association optimization.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface DissociatableManagedConnection {

    /**
     * This method is called by an application server (that is capable
     * of lazy connection association optimization) in order to
     * dissociate a ManagedConnection instance from all of its
     * connection handles.
     * @throws ResourceException generic exception if operation fails.
     * @throws ResourceAdapterInternalException resource adapter internal
     *         error condition
     * @throws IllegalStateException Illegal state for calling connection
     *         cleanup. Example - if a {@link LocalTransaction} is in progress
     *         that doesn't allow connection cleanup.
     */
    void dissociateConnections() throws ResourceException;
}
