/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LocalTransaction.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * LocalTransaction interface provides support for transactions that
 * are managed internal to an EIS resource manager, and do not require
 * an external transaction manager.<br/>
 * 
 * A resource adapter implements the javax.resource.spi.LocalTransaction
 * interface to provide support for local transactions that are performed
 * on the underlying resource manager.<br/>
 * 
 * If a resource adapter supports the LocalTransaction interface, then
 * the application server can choose to perform local transaction
 * optimization (uses local transaction instead of a JTA transaction
 * for a single resource manager case).
 * @version 0.5
 * @author Guillaume Sauthier
 */
public interface LocalTransaction {

    /**
     * Begin a local transaction.
     * @throws ResourceException generic exception if operation fails
     * @throws LocalTransactionException error condition related to
     *         local transaction management
     * @throws ResourceAdapterInternalException error condition internal
     *         to resource adapter
     * @throws EISSystemException EIS instance specific error condition
     */
    void begin() throws ResourceException;
    
    /**
     * Commit a local transaction.
     * @throws ResourceException generic exception if operation fails 
     * @throws LocalTransactionException error condition related to
     *         local transaction management
     * @throws ResourceAdapterInternalException error condition internal
     *         to resource adapter
     * @throws EISSystemException EIS instance specific error condition
     */
    void commit() throws ResourceException;
    
    /**
     * Rollback a local transaction.
     * @throws ResourceException generic exception if operation fails 
     * @throws LocalTransactionException error condition related to
     *         local transaction management
     * @throws ResourceAdapterInternalException error condition internal
     *         to resource adapter
     * @throws EISSystemException EIS instance specific error condition
     */
    void rollback() throws ResourceException;
}
