/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TransactionContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * A standard WorkContext that allows a Work instance to propagate transaction related context information from an EIS to an
 * application server.
 * 
 * This class extends ExecutionContext so that a resource adapter developer could migrate their existing code from
 * ExecutionContext to TransactionContext easily.
 * @since 1.6
 * @author Florent Benoit
 */
public class TransactionContext  extends ExecutionContext implements WorkContext {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 6205067498708597824L;

    /**
     * Constructs a new TransactionContext.
     */
    public TransactionContext() {

    }

    /**
     * Get the brief description of the role played by the WorkContext and any other related debugging information.
     */
    public String getDescription() {
        return TransactionContext.class.getName();
    }

    /**
     * Get the associated name of the WorkContext.
     */
    public String getName() {
        return TransactionContext.class.getName();
    }

}
