/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: XpathEvent.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.model;

import java.beans.PropertyChangeEvent;

/**
 * An Event class describing ConfigBeans being added/subtracted from a server configuration.
 * @author Guillaume Sauthier
 */
public final class XpathEvent {

    /**
     * Adding a {@link DDBean}.
     */
    public static final Object BEAN_ADDED = "BEAN_ADDED";

    /**
     * Removing a {@link DDBean}.
     */
    public static final Object BEAN_REMOVED = "BEAN_REMOVED";

    /**
     * Changin a {@link DDBean}.
     */
    public static final Object BEAN_CHANGED = "BEAN_CHANGED";

    /**
     * The ConfigBean source of the event.
     */
    private DDBean bean;

    /**
     * The event type.
     */
    private Object type;

    /**
     * The {@link PropertyChangeEvent}.
     */
    private PropertyChangeEvent changeEvent;

    /**
     * A description of a change in the ConfigBean tree.
     * @param bean The ConfigBean being added/removed.
     * @param type Indicates an add/remove event.
     */
    public XpathEvent(DDBean bean,
                      Object type) {
        this.bean = bean;
        this.type = type;
    }

    public PropertyChangeEvent getChangeEvent() {
        return this.changeEvent;
    }

    public void setChangeEvent(PropertyChangeEvent pce) {
        this.changeEvent = pce;
    }

    public DDBean getBean() {
        return this.bean;
    }

    public boolean isAddEvent() {
        return this.type.equals(BEAN_ADDED);
    }

    public boolean isRemoveEvent() {
        return this.type.equals(BEAN_REMOVED);
    }

    public boolean isChangeEvent() {
        return this.type.equals(BEAN_CHANGED);
    }


}
