/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Interceptor.java 5349 2010-02-17 14:40:34Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.interceptor;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Specifies that a class is an interceptor.
 * <pre>
 *  &#064;Interceptor
 *  public class ValidationInterceptor { ... }
 * </pre>
 * 
 * This annotation is optional if {@linkplain Interceptors &#064;Interceptors} or the EJB deployment
 * descriptor are used to associate the interceptor with the target class. It is required when
 * an {@linkplain InterceptorBinding interceptor binding} is used.
 * 
 * @author Guillaume Sauthier
 * @see Interceptors
 * @since Interceptor 1.1
 */
@Target(TYPE)
@Retention(RUNTIME)
@Documented
public @interface Interceptor {}
