/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TrustStoreCallback.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.callback;

import java.security.KeyStore;

/**
 * Callback for trusted certificate KeyStore.
 *
 * <p />
 *
 * A trusted certificate KeyStore may be used to determine
 * whether a given certificate chain can be trusted.
 *
 * @version 1.0
 */
public class TrustStoreCallback implements javax.security.auth.callback.Callback {
    private static final long serialVersionUID = -7843835600731075799L;

    /**
     * The trust store, SET by the callback handler.
     */
    private KeyStore theTrustStore;


    /**
     * Create a TrustStoreCallback.
     */
    public TrustStoreCallback() {
    }

    /**
     * Used by the CallbackHandler to set the trusted certificate keystore
     * within the Callback.
     *
     * @param trustStore The trusted certificate KeyStore,
     *		which must already be loaded.
     */
    public void setTrustStore(KeyStore trustStore) {
	this.theTrustStore = trustStore;
    }

    /**
     * Used by the TrustStore user to obtain the TrustStore set within the
     * Callback.
     *
     * @return The trusted certificate KeyStore.
     *          The KeyStore is guaranteed to already be loaded.
     */
    public KeyStore getTrustStore() {
	return this.theTrustStore;
    }

}
