/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuthConfig.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.config;

import javax.security.auth.message.MessageInfo;

/**
 * This interface defines the common functionality implemented by
 * Authentication context configuration objects.
 *
 * @version 1.0
 * @see ClientAuthContext
 * @see ServerAuthContext
 */
public interface AuthConfig {
    /**
     * Get the message layer name of this authentication context configuration
     * object.
     *
     * @return The message layer name of this configuration object, or null if
     * the configuration object pertains to an unspecified message layer.
     */
    public String getMessageLayer();


    /**
     * Get the application context identifier of this authentication
     * context configuration object.
     *
     * @return The String identifying the application context of this
     * configuration object, or null if the configuration object pertains
     * to an unspecified application context.
     */
    public String getAppContext();

    /**
     * Get the authentication context identifier corresponding to the
     * request and response objects encapsulated in messageInfo.
     *
     * @param messageInfo A contextual Object that encapsulates the
     *          client request and server response objects.
     *
     * @return The authentication context identifier corresponding to the
     *          encapsulated request and response objects, or null.
     *
     * @throws IllegalArgumentException If the type of the message
     * objects incorporated in messageInfo are not compatible with
     * the message types supported by this
     * authentication context configuration object.
     */
    public String getAuthContextID(MessageInfo messageInfo);

    /**
     * Causes a dynamic authentication context configuration object to
     * update the internal state that it uses to process calls to its
     * <code>getAuthContext</code> method.
     *
     * @exception AuthException If an error occurred during the update.
     *
     * @exception SecurityException If the caller does not have permission
     *          to refresh the configuration object.
     */
    public void refresh();

    /**
     * Used to determine whether the authentication context configuration
     * object encapsulates any protected authentication contexts.
     *
     * @return True if the configuration object encapsulates at least one
     *        protected authentication context. Otherwise, this method
     *        returns false.
     */
    public boolean isProtected();
}
