/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ClientAuthModule.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.module;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.ClientAuth;
import javax.security.auth.message.MessagePolicy;

/**
 * A ClientAuthModule secures request messages, and validates received
 * response messages.
 *
 * <p> A module implementation should assume it may be used to secure
 * different requests as different clients. A module should also assume
 * it may be used concurrently by multiple callers.  It is the module
 * implementation's responsibility to properly save and restore any state
 * as necessary.  A module that does not need to do so
 * may remain completely stateless.
 *
 * <p> Every implementation of the interface must provide a public zero
 * argument contructor.
 *
 * @version %I%, %G%
 *
 * @see ClientAuthContext
 */
public interface ClientAuthModule extends ClientAuth {

    /**
     * Initialize this module with request and response message policies
     * to enforce, a CallbackHandler, and any module-specific configuration
     * properties.
     *
     * <p> The request policy and the response policy must not both be null.
     *
     * @param requestPolicy The request policy this module must enforce,
     *          or null.
     *
     * @param responsePolicy The response policy this module must enforce,
     *          or null.
     *
     * @param handler CallbackHandler used to request information.
     *
     * @param options A Map of module-specific configuration properties.
     *
     * @exception AuthException If module initialization fails, including for
     * the case where the options argument contains elements that are not
     * supported by the module.
     */
    void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy,
            CallbackHandler handler, Map options) throws AuthException;

    /**
     * Get the one or more Class objects representing the message types
     * supported by the module.
     *
     * @return An array of Class objects where each element
     * defines a message type supported by the module.
     * A module should return an array containing at
     * least one element. An empty array indicates that the module
     * will attempt to support any message type. This method
     * never returns null.
     */
    public Class[] getSupportedMessageTypes();

}
