/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuthConfigFactoryAbstractImpl.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.config;

import java.util.Map;

/**
 * Non-working implementation of the factory (zero-argument constructor
 * but ABSTRACT).
 * @author Marian Muller
 */
public abstract class AuthConfigFactoryAbstractImpl extends AuthConfigFactory {
    public AuthConfigFactoryAbstractImpl() {
    }
    @Override
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    @Override
    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
