/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Endpoint.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws;

import org.w3c.dom.Element;

import javax.xml.transform.Source;
import javax.xml.ws.spi.Provider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 28 juil. 2008
 * Time: 22:26:56
 * To change this template use File | Settings | File Templates.
 */
public abstract class Endpoint {

    public static final String WSDL_SERVICE = "javax.xml.ws.wsdl.service";
    public static final String WSDL_PORT = "javax.xml.ws.wsdl.port";

    public static Endpoint create(Object implementor) {
        return create(null, implementor);
    }

    public static Endpoint create(String bindingId,
                                  Object implementor) {
        return Provider.provider().createEndpoint(bindingId, implementor);
    }

    public static Endpoint publish(String address,
                                   Object implementor) {
        return Provider.provider().createAndPublishEndpoint(address, implementor);
    }

    public abstract Binding getBinding();

    public abstract Object getImplementor();

    public abstract void publish(String address);

    public abstract void publish(Object serverContext);

    public abstract void stop();

    public abstract boolean isPublished();

    public abstract List<Source> getMetadata();

    public abstract void setMetadata(List<Source> metadata);

    public abstract Executor getExecutor();

    public abstract void setExecutor(Executor executor);

    public abstract Map<String, Object> getProperties();

    public abstract void setProperties(Map<String, Object> properties);

    public abstract EndpointReference getEndpointReference(Element... referenceParameters);

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> clazz,
                                                                         Element... referenceParameters);

    

}
