/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Provider.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.spi;

import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import java.net.URL;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 9 dc. 2008
 * Time: 20:26:59
 * To change this template use File | Settings | File Templates.
 */
public abstract class Provider {
    public static final String JAXWSPROVIDER_PROPERTY = "javax.xml.ws.spi.Provider";

    protected Provider() {
    }

    public static Provider provider() {
        // TODO OSGi Provider services to be returned
        return StandardProviderResolver.find(Provider.class);
    }

    public abstract ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation,
                                                          QName serviceName,
                                                          Class serviceClass);

    public abstract Endpoint createEndpoint(String bindingId,
                                        Object implementor);

    public abstract Endpoint createAndPublishEndpoint(String address,
                                                  Object implementor);

    public abstract <T> T getPort(EndpointReference endpointReference,
                              Class<T> serviceEndpointInterface,
                              WebServiceFeature... features);

    public abstract W3CEndpointReference createW3CEndpointReference(String address,
                                                                QName serviceName,
                                                                QName portName,
                                                                List<Element> metadata,
                                                                String wsdlDocumentLocation,
                                                                List<Element> referenceParameters);

    public abstract EndpointReference readEndpointReference(Source eprInfoset);
}
