/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FlushModeType.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * When queries are executed within a transaction, if FlushModeType.AUTO is set
 * on the Query object, or if the flush mode setting for the persistence context
 * is AUTO (the default) and a flush mode setting has not been specified for the
 * Query object, the persistence provider is responsible for ensuring that all
 * updates to the state of all entities in the persistence context which could
 * potentially affect the result of the query are visible to the processing of
 * the query. The persistence provider implementation may achieve this by
 * flushing those entities to the database or by some other means. If FlushMode-
 * Type.COMMIT is set, the effect of updates made to entities in the persistence
 * context upon queries is unspecified.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
public enum FlushModeType {

    /**
     * Commit mode.
     */
    COMMIT,

    /**
     * Auto mode.
     */
    AUTO
}
